<?php
/**
 * Background Pattern Style - Confetti.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Pattern_Confetti
 *
 * @since 4.15.0
 */
class ET_Builder_Pattern_Confetti extends ET_Builder_Background_Pattern_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Confetti', 'et-builder' ),
			'svgContent' => array(
				'default'          => '<path d="M150.25,58l-7.2-3.5a20.42,20.42,0,1,1,36.71,17.88l-7.19-3.5A12.42,12.42,0,0,0,150.25,58ZM20.93,48.68l-6.17-5.1A12.41,12.41,0,0,1,0,46.94v8.48a20.6,20.6,0,0,0,5.17.67A20.38,20.38,0,0,0,20.93,48.68Zm376.35-3.43a12.43,12.43,0,0,1-1.67-17.48l-6.17-5.09a20.44,20.44,0,0,0,2.75,28.74,20.19,20.19,0,0,0,7.81,4V46.94A12.17,12.17,0,0,1,397.28,45.25Zm-137.62,153h-.09l0,8a12.43,12.43,0,0,1,12.47,12.37l8,0A20.44,20.44,0,0,0,259.66,198.2ZM97,210.39a12.41,12.41,0,0,1-20.45,10.38,12.28,12.28,0,0,1-4.3-8.47l-8,.62a20.44,20.44,0,0,0,20.34,18.84q.8,0,1.59-.06A20.43,20.43,0,0,0,105,209.77ZM227.69,42.08l6.62,4.5,22-32.33-6.62-4.5ZM36.75,154.67,8.15,128,2.7,133.84l28.59,26.68ZM359.28,258l5.48,5.83,28.51-26.77-5.47-5.83ZM310.33,115.33a13,13,0,1,1-13-13A13,13,0,0,1,310.33,115.33Zm-8,0a5,5,0,1,0-5,5A5,5,0,0,0,302.33,115.33ZM38,268.62a13,13,0,1,1-13-13A13,13,0,0,1,38,268.62Zm-8,0a5,5,0,1,0-5,5A5,5,0,0,0,30,268.62Zm165.45-43.47a9,9,0,1,0,9,9A9,9,0,0,0,195.47,225.15ZM365.14,57.48a9,9,0,1,0-9,9A9,9,0,0,0,365.14,57.48ZM172.83,164.26a6.36,6.36,0,1,0-6.36,6.36A6.37,6.37,0,0,0,172.83,164.26Zm176,6.73a4.69,4.69,0,1,0,4.68,4.69A4.69,4.69,0,0,0,348.8,171ZM263.15,287.32a4.68,4.68,0,1,0,4.68,4.68A4.67,4.67,0,0,0,263.15,287.32ZM77.47,96.73a9,9,0,1,0-9-9A9,9,0,0,0,77.47,96.73Zm24.63,33.69-7.16,17.09L112,154.68A18.54,18.54,0,0,0,102.1,130.42ZM217,129.1l18-4.37-4.37-18A18.52,18.52,0,0,0,217,129.1ZM88.76,0H74.07l6.51,7.3ZM68.25,293.46,74.07,300H88.76l5.65-5A18.54,18.54,0,0,0,68.25,293.46Z"/>',
				'default-inverted' => '<path d="M30,268.62a5,5,0,1,1-5-5A5,5,0,0,1,30,268.62ZM297.33,110.33a5,5,0,1,0,5,5A5,5,0,0,0,297.33,110.33Zm94.86-58.91a20.19,20.19,0,0,0,7.81,4V300H88.76l5.65-5a18.54,18.54,0,0,0-26.16-1.51L74.07,300H0V55.42a20.6,20.6,0,0,0,5.17.67,20.38,20.38,0,0,0,15.76-7.41l-6.17-5.1A12.41,12.41,0,0,1,0,46.94V0H74.07l6.51,7.3L88.76,0H400V46.94a12.17,12.17,0,0,1-2.72-1.69,12.43,12.43,0,0,1-1.67-17.48l-6.17-5.09A20.44,20.44,0,0,0,392.19,51.42ZM68.47,87.73a9,9,0,1,0,9-9A9,9,0,0,0,68.47,87.73ZM2.7,133.84l28.59,26.68,5.46-5.85L8.15,128ZM38,268.62a13,13,0,1,0-13,13A13,13,0,0,0,38,268.62ZM105,209.77l-8,.62a12.41,12.41,0,0,1-20.45,10.38,12.28,12.28,0,0,1-4.3-8.47l-8,.62a20.44,20.44,0,0,0,20.34,18.84q.8,0,1.59-.06A20.43,20.43,0,0,0,105,209.77Zm-2.85-79.35-7.16,17.09L112,154.68A18.54,18.54,0,0,0,102.1,130.42Zm64.75-78.1a12.43,12.43,0,0,1,5.72,16.6l7.19,3.5a20.42,20.42,0,0,0-36.71-17.88l7.2,3.5A12.43,12.43,0,0,1,166.85,52.32Zm-.38,118.3a6.37,6.37,0,1,0-6.36-6.36A6.36,6.36,0,0,0,166.47,170.62Zm38,63.53a9,9,0,1,0-9,9A9,9,0,0,0,204.47,234.15ZM235,124.73l-4.37-18A18.52,18.52,0,0,0,217,129.1ZM256.31,14.25l-6.62-4.5-22,32.33,6.62,4.5ZM267.83,292a4.68,4.68,0,1,0-4.68,4.68A4.68,4.68,0,0,0,267.83,292Zm12.24-73.46a20.44,20.44,0,0,0-20.41-20.34h-.09l0,8a12.43,12.43,0,0,1,12.47,12.37Zm30.26-103.21a13,13,0,1,0-13,13A13,13,0,0,0,310.33,115.33Zm43.15,60.35a4.68,4.68,0,1,0-4.68,4.68A4.68,4.68,0,0,0,353.48,175.68Zm2.66-109.2a9,9,0,1,0-9-9A9,9,0,0,0,356.14,66.48Zm37.13,170.58-5.47-5.83L359.28,258l5.48,5.83Z"/>',
				'rotated'          => '<path d="M58,249.75l-3.5,7.2a20.42,20.42,0,1,1,17.88-36.71l-3.5,7.19A12.42,12.42,0,0,0,58,249.75ZM48.68,379.07l-5.1,6.17A12.41,12.41,0,0,1,46.94,400h8.48a20.6,20.6,0,0,0,.67-5.17A20.38,20.38,0,0,0,48.68,379.07ZM45.25,2.72a12.33,12.33,0,0,1-8.39,4.45,12.33,12.33,0,0,1-9.09-2.78l-5.09,6.17A20.44,20.44,0,0,0,51.42,7.81a20.19,20.19,0,0,0,4-7.81H46.94A12.17,12.17,0,0,1,45.25,2.72Zm153,137.62v.09l8,0a12.43,12.43,0,0,1,12.37-12.47l0-8A20.44,20.44,0,0,0,198.2,140.34ZM210.39,303a12.41,12.41,0,0,1,10.38,20.45,12.28,12.28,0,0,1-8.47,4.3l.62,8a20.44,20.44,0,0,0,18.84-20.34q0-.8-.06-1.59a20.43,20.43,0,0,0-21.93-18.78ZM42.08,172.31l4.5-6.62-32.33-22-4.5,6.62ZM154.67,363.25,128,391.85l5.85,5.45,26.68-28.59ZM258,40.72l5.83-5.48L237.06,6.73l-5.83,5.47Zm-142.67,49a13,13,0,1,1-13,13A13,13,0,0,1,115.33,89.67Zm0,8a5,5,0,1,0,5,5A5,5,0,0,0,115.33,97.67ZM268.62,362a13,13,0,1,1-13,13A13,13,0,0,1,268.62,362Zm0,8a5,5,0,1,0,5,5A5,5,0,0,0,268.62,370ZM225.15,204.53a9,9,0,1,0,9-9A9,9,0,0,0,225.15,204.53ZM57.48,34.86a9,9,0,1,0,9,9A9,9,0,0,0,57.48,34.86ZM164.26,227.17a6.36,6.36,0,1,0,6.36,6.36A6.37,6.37,0,0,0,164.26,227.17ZM171,51.2a4.69,4.69,0,1,0,4.69-4.68A4.69,4.69,0,0,0,171,51.2Zm116.33,85.65a4.68,4.68,0,1,0,4.68-4.68A4.67,4.67,0,0,0,287.32,136.85ZM96.73,322.53a9,9,0,1,0-9,9A9,9,0,0,0,96.73,322.53Zm33.69-24.63,17.09,7.16L154.68,288A18.54,18.54,0,0,0,130.42,297.9ZM129.1,183l-4.37-18-18,4.37A18.52,18.52,0,0,0,129.1,183ZM0,311.24v14.69l7.3-6.51Zm293.46,20.51,6.54-5.82V311.24l-5-5.65A18.54,18.54,0,0,0,293.46,331.75Z"/>',
				'rotated-inverted' => '<path d="M268.62,370a5,5,0,1,1-5,5A5,5,0,0,1,268.62,370ZM110.33,102.67a5,5,0,1,0,5-5A5,5,0,0,0,110.33,102.67ZM51.42,7.81a20.19,20.19,0,0,0,4-7.81H300V311.24l-5-5.65a18.54,18.54,0,0,0-1.51,26.16l6.54-5.82V400H55.42a20.6,20.6,0,0,0,.67-5.17,20.38,20.38,0,0,0-7.41-15.76l-5.1,6.17A12.41,12.41,0,0,1,46.94,400H0V325.93l7.3-6.51L0,311.24V0H46.94a12.17,12.17,0,0,1-1.69,2.72,12.33,12.33,0,0,1-8.39,4.45,12.33,12.33,0,0,1-9.09-2.78l-5.09,6.17A20.44,20.44,0,0,0,51.42,7.81ZM87.73,331.53a9,9,0,1,0-9-9A9,9,0,0,0,87.73,331.53Zm46.11,65.77,26.68-28.59-5.85-5.46L128,391.85ZM268.62,362a13,13,0,1,0,13,13A13,13,0,0,0,268.62,362Zm-58.85-66.93.62,8a12.41,12.41,0,0,1,10.38,20.45,12.28,12.28,0,0,1-8.47,4.3l.62,8a20.44,20.44,0,0,0,18.84-20.34q0-.8-.06-1.59a20.43,20.43,0,0,0-21.93-18.78Zm-79.35,2.85,17.09,7.16L154.68,288A18.54,18.54,0,0,0,130.42,297.9Zm-78.1-64.75a12.43,12.43,0,0,1,16.6-5.72l3.5-7.19A20.42,20.42,0,0,0,54.54,257l3.5-7.2A12.43,12.43,0,0,1,52.32,233.15Zm118.3.38a6.37,6.37,0,1,0-6.36,6.36A6.36,6.36,0,0,0,170.62,233.53Zm63.53-38a9,9,0,1,0,9,9A9,9,0,0,0,234.15,195.53ZM124.73,165l-18,4.37A18.52,18.52,0,0,0,129.1,183ZM14.25,143.69l-4.5,6.62,32.33,22,4.5-6.62ZM292,132.17a4.68,4.68,0,1,0,4.68,4.68A4.68,4.68,0,0,0,292,132.17Zm-73.46-12.24a20.44,20.44,0,0,0-20.34,20.41v.09l8,0a12.43,12.43,0,0,1,12.37-12.47ZM115.33,89.67a13,13,0,1,0,13,13A13,13,0,0,0,115.33,89.67Zm60.35-43.15a4.68,4.68,0,1,0,4.68,4.68A4.68,4.68,0,0,0,175.68,46.52ZM66.48,43.86a9,9,0,1,0-9,9A9,9,0,0,0,66.48,43.86ZM237.06,6.73l-5.83,5.47L258,40.72l5.83-5.48Z"/>',
				'thumbnail'        => '<path d="M30.05,11.61l-1.44-.7A4.08,4.08,0,0,1,34.07,9,4.07,4.07,0,0,1,36,14.48l-1.44-.7a2.48,2.48,0,1,0-4.46-2.17ZM4.19,9.74,3,8.72A2.49,2.49,0,0,1,0,9.39v1.69a4.06,4.06,0,0,0,1,.14A4.11,4.11,0,0,0,4.19,9.74Zm75.27-.69a2.5,2.5,0,0,1-.34-3.5l-1.23-1a4.08,4.08,0,0,0,.55,5.74,3.94,3.94,0,0,0,1.56.8V9.39A2.57,2.57,0,0,1,79.46,9.05ZM51.93,39.64h0v1.6a2.47,2.47,0,0,1,2.49,2.47H56A4.08,4.08,0,0,0,51.93,39.64ZM15.39,43.08a2.47,2.47,0,0,1-2.28,2.66,2.41,2.41,0,0,1-1.81-.59,2.47,2.47,0,0,1-.86-1.69l-1.59.12a4.09,4.09,0,0,0,4.07,3.77h.31A4.09,4.09,0,0,0,17,43ZM45.54,8.42l1.32.9,4.4-6.47L49.94,2ZM7.35,30.93,1.63,25.6.54,26.77,6.26,32.1ZM71.86,51.6,73,52.77l5.7-5.36-1.09-1.16ZM62.07,23.07a2.6,2.6,0,1,1-2.6-2.6A2.61,2.61,0,0,1,62.07,23.07Zm-1.6,0a1,1,0,1,0-1,1A1,1,0,0,0,60.47,23.07ZM7.6,53.72A2.6,2.6,0,1,1,5,51.12,2.59,2.59,0,0,1,7.6,53.72Zm-1.6,0a1,1,0,1,0-1,1A1,1,0,0,0,6,53.72ZM35.09,45a1.8,1.8,0,1,0,1.8,1.8A1.81,1.81,0,0,0,35.09,45ZM73,11.5a1.8,1.8,0,1,0-1.8,1.8A1.8,1.8,0,0,0,73,11.5ZM34.57,32.85a1.28,1.28,0,1,0-1.28,1.27A1.27,1.27,0,0,0,34.57,32.85ZM69.76,34.2a.94.94,0,1,0,.94.94A.94.94,0,0,0,69.76,34.2ZM52.63,57.46a.94.94,0,1,0,.94.94A.94.94,0,0,0,52.63,57.46ZM17.49,19.35a1.8,1.8,0,1,0-1.8-1.8A1.8,1.8,0,0,0,17.49,19.35Zm.93,9.73L17,32.5l3.42,1.44A3.72,3.72,0,0,0,18.42,29.08Zm27-3.26L49,25l-.88-3.6A3.69,3.69,0,0,0,45.41,25.82ZM17.75,0H14.81l1.31,1.46Zm-4.1,58.69L14.81,60h2.94l1.13-1A3.71,3.71,0,0,0,13.65,58.69Z"/>',
			),
			'width'      => '400px',
			'height'     => '300px',
		);
	}
}

return new ET_Builder_Pattern_Confetti();
