// On choppe les 2 éléments HTML dans lesquels on va injecter des choz
const gallery = document.querySelector('.users-pics')
const userDet = document.querySelector('.user-details')

// On va chercher les datas
fetch(`./scripts/datas.json`)
  .then(response => response.json())
  .then(data => {
    // console.log(data.users);
    function displayUsers() {
      data.users.forEach(function(singleUser){
        gallery.innerHTML += `
        <img class="user-img" data-userid="${singleUser.id}" src="${singleUser.image}" title="${singleUser.name}">
        `
      })
    }
    function displaySingleUser(user) {
      address = user.address.street + user.address.city + user.address.country
      userDet.innerHTML = `
      <div class="user-details">
        <img src="${user.image}" alt="${user.name}">
        <h2>${user.name}</h2>
        <div class="age">${user.age}</div>
        <a class="contact" href="mailto:${user.email}" title="Envoyez un email à ${user.name}"><i class="fa-solid fa-envelope" aria-hidden="true"></i></a>
        <div class="address">${address}</div>
      </div>
      `
    }
    
      gallery.addEventListener('click', function(e){
        if(e.target.classList.contains('user-img')) {
          displaySingleUser(data.users[e.target.getAttribute('data-userid')-1])
        }
      })

    displayUsers()

  })
  .catch(error => {console.log("Erreur lors de la récup des données :", error);
})

