// documentation et code pour le multi select: https://jsfiddle.net/Dr_Folaweb/3qkvuptf/?fbclid=IwAR1_eq9h1jx2LqBpMQITnbj_zTcz75UYISNx4O4GfpFUMbXKCERPmokLxjI

let cars = {
    "Hh": { marque: "honda", type: "hybride", prix:30520, img: "honda_hybride.jpg" },
    "He": { marque: "honda", type: "electrique", prix:47860, img: "honda_electrique.jpg" },
    "Kh": { marque: "Kia", type: "hybride", prix:33190, img: "kia_hybride.png" },
    "Ke": { marque: "Kia", type: "electrique", prix:33790, img: "kia_electrique.png" },
    "Sh": { marque: "Skoda", type: "hybride", prix:27920, img: "skoda_hybride.png" },
    "Se": { marque: "Skoda", type: "electrique", prix:39629, img: "skoda_electrique.png" }
}
let optionPrices = {
    retro: 750,
    sieges: 500,
    volant: 375,
    stationnement: 525,
    recul: 925
};
let coutBorne = 575;
let coutInstall = 1300;
// let ecoAnnuelle = 700; en bonus, moi je l'ai pas encore fait

let carSelect = document.querySelector("#car");
let totalPrice = document.querySelector(".cout_total")
let divResultat = document.querySelector("#resultat");
let btnEnvoi = document.querySelector(".btn_envoi");
let optionSelect = document.querySelector("#options");
let imgVoiture = document.querySelector(".tuture")
let mensualites3ans = document.querySelector(".sur_3ans")
let mensualites5ans = document.querySelector(".sur_5ans")

btnEnvoi.addEventListener("click", calcul)
carSelect.addEventListener("change", prixVoiture)
carSelect.addEventListener("change", photoVoiture)
optionSelect.addEventListener("change", prixVoiture)

function photoVoiture(){
    let myCar = carSelect.value;
    let image = cars[myCar].img
    imgVoiture.src="img/"+image
}

function addCar(){
    let myCar = carSelect.value;
    let carPrice = 0
    if(cars[myCar].type === "hybride"){
        //calcul pour les hybrides
        carPrice = cars[myCar].prix 
    } else {
        // calcul pour les electriques
        carPrice = cars[myCar].prix + coutBorne + coutInstall
    }
    return carPrice
}

function addOptions(){
    let mySelectedOptions = []
    let prixOptions = 0

    for (let optionItem of optionSelect.options){
        if (optionItem.selected){
            mySelectedOptions.push(optionItem.value)
        }
    }
    mySelectedOptions.forEach(function (item){
        prixOptions += optionPrices[item]
    })
    return prixOptions
}

function prixVoiture(){
    let prixTotalDeLaVoiture = addCar() + addOptions()
    totalPrice.innerHTML = `${prixTotalDeLaVoiture} €`
}

// function remboursement(prix_voiture, prix_options){
//     let mensua3 = ((prix_voiture + prix_options) / (12*3)).toFixed(2)
//     mensualites3ans.innerHTML = `${mensua3}€ par mois pendant 3 ans`
//     let mensua5 = ((prix_voiture + prix_options) / (12*5)).toFixed(2)
//     mensualites5ans.innerHTML = `${mensua5}€ par mois pendant 5 ans`
// }

// function calcul(){
//     let calculatedCarPrice = addCar()
//     let calculatedOptions = addOptions()
//     remboursement(calculatedCarPrice, calculatedOptions)
// }

function remboursement(prix_voiture, prix_options, duree){
    let mensua = ((prix_voiture + prix_options) / (12*duree)).toFixed(2)
    return `${mensua}€ par mois pendant ${duree} ans`
}

function calcul(){
    let calculatedCarPrice = addCar()
    let calculatedOptions = addOptions()
    mensualites3ans.innerHTML = remboursement(calculatedCarPrice, calculatedOptions, 3)
    mensualites5ans.innerHTML = remboursement(calculatedCarPrice, calculatedOptions, 5)
}