<?php
/**
 * Background Mask Style - Blades.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Mask_Blades
 *
 * @since 4.15.0
 */
class ET_Builder_Mask_Blades extends ET_Builder_Background_Mask_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Blades', 'et-builder' ),
			'svgContent' => array(
				'default'          => array(
					'landscape' => '<path d="M1919.53,694.81q0-29.94,0-59.74L1648,917.13v-7.3l271.5-282.05c0-131.69-.06-259.19,0-364.49L1005,1213.3V387L1377.55,0H0V1440H1202.22Z"/>
									<path d="M1585.93,1440H1920s-.12-146.87-.26-346.79Z"/>',
					'portrait'  => '<polygon points="1919.53 694.81 1919.51 635.07 1648 917.13 1648 909.83 1919.5 627.78 1919.47 263.29 1005 1213.3 1005 387.03 1377.56 0 0 0 0 1920 740 1920 1919.53 694.81"/>
									<polygon points="1124 1920 1920 1920 1919.74 1093.21 1124 1920"/>',
					'square'    => '<polygon points="1919.74 1093.21 769.79 2288 385.84 2288 1919.53 694.81 1919.51 635.07 1648 917.13 1648 909.83 1919.5 627.78 1919.47 263.29 1005 1213.3 1005 387.03 1377.56 0 0 0 0 2560 1919.5 2560 1920 2560 1919.74 1093.21"/>',
				),
				'default-inverted' => array(
					'landscape' => '<path d="M1920,0V260.31l-915,953V387L1377.55,0ZM1648,909.83v7.3l272-284.59v-7.3ZM1202.22,1440h383.71L1920,1090.83V692Z"/>',
					'portrait'  => '<path d="M1920,691.2V1090L769.79,2288H385.84ZM1648,909.83v7.3l272-284.62v-7.3ZM1377.55,0,1005,387V1213.3l915-953.45V0Z"/>',
					'square'    => '<path d="M1920,625.21v7.3L1648,917.13v-7.3ZM740,1920h384l796-829.85V691.29ZM1377.55,0,1005,387V1213.3l915-953.45V0Z"/>',
				),
				'rotated'          => array(
					'landscape' => '<path d="M1174.81.47l-59.74,0L1397.13,272h-7.3L1107.78.5c-131.69,0-259.19.06-364.49,0L1693.3,915H867L0,80V1440H1920V717.78Z"/>
									<path d="M1920,334.07V0s-146.87.13-346.79.26Z"/>',
					'portrait'  => '<polygon points="694.81 0.47 635.07 0.49 917.13 272 909.83 272 627.78 0.5 263.29 0.53 1213.3 915 387.03 915 0 542.45 0 2560 1920 2560 1920 1180 694.81 0.47"/>
									<polygon points="1920 796 1920 0 1093.21 0.26 1920 796"/>',
					'square'    => '<polygon points="694.81 0.47 635.07 0.49 917.13 272 909.83 272 627.78 0.5 263.29 0.53 1213.3 915 387.03 915 0 542.45 0 1920 1920 1920 1920 1180 694.81 0.47"/>
									<polygon points="1920 796 1920 0 1093.21 0.26 1920 796"/>',
				),
				'rotated-inverted' => array(
					'landscape' => '<path d="M0,0H741.39L1693.3,915H867L0,80ZM1389.83,272h7.3L1114.57,0h-6.83ZM1175,0l745,717.78V334.07L1573.14,0Z"/>',
					'portrait'  => '<path d="M0,0,262.32.06,1786.3,1477H960L0,542.45ZM909.83,272h7.3L634.88.15H628.2ZM1920,796,1093.21.26,694.9.16,1920,1180Z"/>',
					'square'    => '<path d="M0,0,262.32.06,1213.3,915H387L0,542.45ZM909.83,272h7.3L634.88.15H628.2ZM1920,796,1093.21.26,694.9.16,1920,1180Z"/>',
				),
			),
		);
	}
}

return new ET_Builder_Mask_Blades();
