var
	sourceFile = 'theme/bower_components/mdi/scss/_icons.scss',
	targetFile = 'theme/scss/icons.scss',
	
	fs = require('fs'),
	rl = require('readline').createInterface({
		input: fs.createReadStream(sourceFile),
		output: process.stdout,
		terminal: false
	}),
	hexes = [], 
	names = [];

rl.on('line', function (line) {
	if (line.slice(0, 6) == "$hexes") {
		hexes = line.split(' ').slice(1);
		var last = hexes[hexes.length - 1];
		hexes[hexes.length - 1] = last.slice(0, last.length - 1);
	}
	if (line.slice(0, 6) == "$names") {
		names = line.split(' ').slice(1);
		names[hexes.length - 1] = names[names.length - 1].slice(0, names[names.length - 1].length - 1);
	}
});

rl.on('close', function () {
	fs.unlinkSync(targetFile);
	hexes.forEach(function (e, i, a) {
		var name = names[i].replace(/'/g, "");
		var hex = ' "\\' + hexes[i].replace(/'/g, "") + '"';
		fs.appendFile(targetFile, '$icon-' + name + ':' + hex + ';\n', function (err) {
			if (err) throw err;
		});
	})
})