//Dependencies
var gulp          = require('gulp'),
    fs            = require('fs'),
    del           = require('del'),
    plumber       = require('gulp-plumber'),
    cssmin        = require('gulp-minify-css'),
    sass          = require('gulp-sass'),
    rename        = require('gulp-rename'),
		preprocess		= require('gulp-preprocess'),
		htmlreplace 	= require('gulp-html-replace'),
		notify        = require('gulp-notify'),
    autoprefixer  = require('gulp-autoprefixer'),
    zip           = require('gulp-zip'),
		replace 			= require('gulp-replace'),
    uglify        = require('gulp-uglify'),
    runSequence   = require('run-sequence'),
    rtlcss        = require('gulp-rtlcss'),
    concat        = require('gulp-concat'),
    browserSync   = require('browser-sync');

//configuration
var config = {};
config.autoprefixer = {browsers: ["Android 2.3","Android >= 4","Chrome >= 20","Firefox >= 24","Explorer >= 8","iOS >= 6","Opera >= 12","Safari >= 6"]};
config.plumber = {errorHandler: function(err){
  notify.onError({
    title:    "SASS",
    subtitle: "Compile failed!",
    message:  "Error: <%= error.message %>",
    sound:    "chord"
  })(err);
  this.emit('end');
}};

//Read package.json
var _package = JSON.parse(fs.readFileSync('./package.json'));


//=================================================
// TASKS
// Separate tasks to avoid recompiling everything
// whenever onChange is triggered on theme files
//=================================================

//main.scss
gulp.task('sass.main', function () {
  return gulp.src('./theme/scss/main.scss')
    .pipe(plumber(config.plumber))
    .pipe(sass({ outputStyle: 'expanded', precision: 8 }))
    .pipe(autoprefixer(config.autoprefixer))
    .pipe(gulp.dest('./theme/css'))
    .pipe(browserSync.stream());
});

//-sceditor.scss
//-themepanel.scss
//-mdi.scss
gulp.task('sass.dependencies', function () {
  return gulp.src(['./theme/scss/sceditor.scss', './theme/scss/themepanel.scss', './theme/scss/mdi.scss'])
    .pipe(plumber(config.plumber))
    .pipe(sass({ outputStyle: 'expanded', precision: 8 }))
    .pipe(autoprefixer(config.autoprefixer))
    .pipe(gulp.dest('./theme/css'))
    .pipe(browserSync.stream());
});

//Watch files
gulp.task('watch', function () {

  browserSync.init();

  gulp.watch(["theme/scss/**/*.scss", "!bootstrap.scss"], ['sass.main']);

  gulp.watch(['theme/scss/themepanel.scss', 'theme/scss/sceditor.scss', 'theme/scss/mdi.scss'], ['sass.dependencies']);

	//reload page
  gulp.watch(['template/**/*','theme/js/**/*.js']).on('change', browserSync.reload);

});


//Concat and minify JS components into main.min.js
gulp.task('JS_min', function(){
  var JScomponents = [
    'theme/js/alert.js',
	  'theme/js/dropdown.js',
    'theme/js/transition.js',
    'theme/js/collapse.js',
    'theme/js/tooltip.js',
    'theme/js/main.js',
  ];
  return gulp.src(JScomponents, {base: './'})
        .pipe(concat('main.min.js')).pipe(uglify({preserveComments: 'some'}))
        .pipe(gulp.dest('theme/js'));
})

//=========================
//RTLCSS
gulp.task('css_rtl', function(){
  return gulp.src('theme/css/main.css', {base: './'})
    .pipe(rtlcss({autoRename: false}))
    .pipe(rename({suffix: '_rtl'}))
    .pipe(gulp.dest('theme/css'));
})


//=========================
//Minify CSS
gulp.task('css_min', function(){
  var files = [
    'theme/css/main.css',
    'theme/css/main_rtl.css'
  ];
  return gulp.src(files, {base: './'})
    .pipe(cssmin())
    .pipe(rename({suffix: '.min'}))
    .pipe(gulp.dest('./'));
})


//=========================
//Preprocess files
//And copy to dist
gulp.task('files_preprocess', function(){
  var files = [
    'template/**/*',
    'theme/css/**/*',
    'theme/js/**/*',
    'theme/*.css',
    'style.cfg'
  ];
  return gulp.src(files, {base: './'})
    .pipe(replace('css/main.css',     'css/main.min.css'))
    .pipe(replace('css/main_rtl.css', 'css/main_rtl.min.css'))
    .pipe(htmlreplace({
      'js': '{T_THEME_PATH}/js/main.min.js?assets_version={T_ASSETS_VERSION}',
      'browserSync': ''
    }))
    .pipe(replace('{{build.name}}', _package.name))
    .pipe(replace('{{build.version}}', _package.version))
    .pipe(replace('{{build.year}}', new Date().getFullYear()))
    .pipe(gulp.dest('dist/theme_install/canvas'));
})



//=========================
//Copy assets to dist
gulp.task('files_assets', function(){
  var files = [
    'theme/images/**/*',
    'theme/bower_components/**/*'
  ];
  return gulp.src(files, {base: './'})
    .pipe(gulp.dest('dist/theme_install/canvas'));
})


//=========================
//Upgrade-package files
gulp.task('files_upgradePackage', function(){
  var files = [
    'style.cfg',
    'dist/theme_install/**/*',
    '!dist/theme_install/canvas/template/custom/*',
    '!dist/theme_install/canvas/theme/images/**/*'
  ];
  return gulp.src(files, {base: './dist/theme_install/canvas'})
    .pipe(gulp.dest('dist/theme_upgrade/canvas'));
})


//=========================
//Dev-package files
gulp.task('files_devPackage', function(){
  var files = [
    'gulpfile.js',
    'icondata.js',
    'package.json',
    'template/**/*',
    'theme/bower.json',
    'theme/scss/**/*'
  ];
  return gulp.src(files, {base: './'})
    .pipe(gulp.dest('dist/theme_dev/canvas'));
})

gulp.task('deldist', function(cb){
  del('dist', cb)
})

gulp.task('build', function(){
  del('dist').then(function () {
  runSequence(
    ['sass.main', 'sass.dependencies'],
    ['JS_min','css_min','css_rtl'],
    ['files_preprocess','files_devPackage'],
    'files_assets',
    'files_upgradePackage'
  );
});
})


gulp.task('default', function() {
	gulp.start('sass.main', 'sass.dependencies', 'watch');
});
